﻿namespace Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Tests
{
    using System.ComponentModel.Composition.Hosting;
    using System.Linq;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Controllers;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using MvcContrib.TestHelper;
    using Moq;

    [TestClass]
    public class RouteTableConfigurationFixture
    {
        [TestMethod]
        public void ShouldHandleEmailSentUrl()
        {
            RouteTable.Routes.Clear();
            RouteCollection routes = new RouteTableConfiguration().RouteCollectionConfiguration;
            routes.ToList().ForEach(RouteTable.Routes.Add);

            "~/Itineraries/Email/EmailSuccess".ShouldMapTo<EmailItineraryController>(c => c.EmailSuccess());
        }

        [TestMethod]
        public void ShouldHandleSendEmailUrl()
        {
            RouteTable.Routes.Clear();
            RouteCollection routes = new RouteTableConfiguration().RouteCollectionConfiguration;
            routes.ToList().ForEach(RouteTable.Routes.Add);

            "~/Itineraries/Email/Email".ShouldMapTo<EmailItineraryController>(c => c.Email(null, null));
        }

        [TestMethod]
        public void ShouldExportCollectionThroughMef()
        {
            var catalog = new TypeCatalog(typeof(RouteTableConfiguration));
            var container = new CompositionContainer(catalog);

            var actual = container.GetExports<RouteCollection>();

            Assert.AreEqual(1, actual.Count());
        }
    }
}
